<?php

// bot function
function bot($method, $data) {
    $url = "https://api.telegram.org/bot" . API_KEY . "/" . $method;

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($ch);

    // Check for cURL errors
    if ($result === false) {
        $error = curl_error($ch);
        error_log("cURL Error: " . $error);
        curl_close($ch);
        return false;
    }

    curl_close($ch);

    return json_decode($result, true);
}

// Send message function
function sendMessage($chat_id, $text, $keyboard = null, $reply_to = null) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text
    ];

    // Add keyboard if provided
    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard);
    }

    // Add reply to message if provided
    if ($reply_to) {
        $data['reply_to_message_id'] = $reply_to;
    }

    return bot('sendMessage', $data);
}

// Get start parameter from deep link
function getStartParameter($text) {
    if (strpos($text, '/start') === 0) {
        $parts = explode(' ', $text, 2);
        if (isset($parts[1]) && !empty($parts[1])) {
            return trim($parts[1]);
        }
    }
    return null;
}

// Send user info to admin when user starts with deep link
function sendUserInfoToAdmin($admin_id, $user_data, $start_param) {
    $username = $user_data['username'] ?? 'بدون یوزرنیم';
    $first_name = $user_data['first_name'] ?? 'بدون نام';
    $last_name = $user_data['last_name'] ?? '';
    $user_id = $user_data['id'];
    $full_name = $first_name . ($last_name ? ' ' . $last_name : '');

    $message = "🔔 کاربر جدید با Deep Link\n\n";
    $message .= "👤 نام: {$full_name}\n";
    $message .= "🆔 شناسه: {$user_id}\n";
    $message .= "📱 یوزرنیم: @{$username}\n";
    $message .= "🔗 پارامتر: {$start_param}";

    return sendMessage($admin_id, $message);
}