<?php
// Inline Keyboard (Glass style) - Parametric
function getInlineKeyboard($type = 'main') {
    $keyboards = [
        'main' => [
            'inline_keyboard' => [
                [
                    ['text' => '📤 آپلود |', 'callback_data' => 'upload'],
                    ['text' => '🚫 بلاک و آنبلاک کردن |', 'callback_data' => 'block']
                ],
                [
                    ['text' => '📊 آمار ربات |', 'callback_data' => 'stats'],
                    ['text' => '🏛 تنظیمات کانال |', 'callback_data' => 'channel_settings'],
                    ['text' => '✉️ ارسال پیام |', 'callback_data' => 'send_message']
                ],
                [
                    ['text' => '👥 ادمین ها |', 'callback_data' => 'admins'],
                    ['text' => '🔔 خاموش و روشن |', 'callback_data' => 'toggle'],
                    ['text' => '📢 ارسال به چنل |', 'callback_data' => 'send_channel']
                ],
                [
                    ['text' => '📣 تبلیغ |', 'callback_data' => 'advertisement'],
                    ['text' => '⚙️ تنظیمات |', 'callback_data' => 'settings'],
                    ['text' => '🔑 تنظیم پسورد |', 'callback_data' => 'set_password']
                ],
                [
                    ['text' => '✏️ تنظیم کپشن |', 'callback_data' => 'set_caption'],
                    ['text' => '👁 تنظیمات سین |', 'callback_data' => 'seen_settings'],
                    ['text' => '❌ تایم حذف مدیا |', 'callback_data' => 'delete_time']
                ],
                [
                    ['text' => '/start', 'callback_data' => 'start']
                ]
            ]
        ],

        'settings' => [
            'inline_keyboard' => [
                [
                    ['text' => '🔙 بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],

        'admins' => [
            'inline_keyboard' => [
                [
                    ['text' => '➕ افزودن ادمین', 'callback_data' => 'add_admin'],
                    ['text' => '➖ حذف ادمین', 'callback_data' => 'remove_admin']
                ],
                [
                    ['text' => '📋 لیست ادمین‌ها', 'callback_data' => 'list_admins']
                ],
                [
                    ['text' => '🔙 بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],

        'channel_settings' => [
            'inline_keyboard' => [
                [
                    ['text' => '🔙 بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ]
    ];

    // If keyboard type exists, return it, otherwise return main keyboard
    return $keyboards[$type] ?? $keyboards['main'];
}

// Reply Keyboard (Normal) - Parametric
function getReplyKeyboard($type = 'main') {
    $keyboards = [
        'main' => [
            'keyboard' => [
                [
                    ['text' => '📤 آپلود |'],
                    ['text' => '🚫 بلاک و آنبلاک کردن |']
                ],
                [
                    ['text' => '📊 آمار ربات |'],
                    ['text' => '🏛 تنظیمات کانال |'],
                    ['text' => '✉️ ارسال پیام |']
                ],
                [
                    ['text' => '👥 ادمین ها |'],
                    ['text' => '🔔 خاموش و روشن |'],
                    ['text' => '📢 ارسال به چنل |']
                ],
                [
                    ['text' => '📣 تبلیغ |'],
                    ['text' => '⚙️ تنظیمات |'],
                    ['text' => '🔑 تنظیم پسورد |']
                ],
                [
                    ['text' => '✏️ تنظیم کپشن |'],
                    ['text' => '👁 تنظیمات سین |'],
                    ['text' => '❌ تایم حذف مدیا |']
                ],
                [
                    ['text' => '/start']
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ],

        'settings' => [
            'keyboard' => [
                [
                    ['text' => '🔙 بازگشت']
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ],

        'admins' => [
            'keyboard' => [
                [
                    ['text' => '➕ افزودن ادمین'],
                    ['text' => '➖ حذف ادمین']
                ],
                [
                    ['text' => '📋 لیست ادمین‌ها']
                ],
                [
                    ['text' => '🔙 بازگشت']
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ]
    ];

    return $keyboards[$type] ?? $keyboards['main'];
}