<?php
// Inline Keyboard (Glass style) - Parametric with Pagination
// @param string $type Keyboard type (main, media, admins, etc.)
// @param int $page Page number for paginated keyboards (default: 1)
// @param array $params Additional parameters (e.g., ['back_to' => 'media', 'file_id' => 123])
function getInlineKeyboard($type = 'main', $page = 1, $params = []) {
    require_once __DIR__ . '/auth.php';
    
        // Check if admin is in user mode and requesting user-related menus
        if (isset($params['user_id']) && isRealAdmin($params['user_id']) && isInUserMode($params['user_id'])) {
            // Map user menus to their "with_exit" versions
            $user_menu_map = [
                'user_menu' => 'user_menu_with_exit',
                'user_points_menu' => 'user_points_menu_with_exit',
                'user_referral_menu' => 'user_referral_menu_with_exit',
                'user_download_menu' => 'user_download_menu_with_exit',
                'user_spin_menu' => 'user_spin_menu_with_exit',
                'user_promo_code_menu' => 'user_promo_code_menu_with_exit',
                'gambling_stats_menu' => 'gambling_stats_menu_with_exit'
            ];
            
            if (isset($user_menu_map[$type])) {
                $type = $user_menu_map[$type];
            }
        }
    
    // All menu items (2 columns per row)
    $all_items = [
        ['text' => '📁 مدیریت مدیا', 'callback_data' => 'media'],
        ['text' => '🔒 مدیریت کاربران', 'callback_data' => 'block'],
        ['text' => '📈 آمار ربات', 'callback_data' => 'stats'],
        ['text' => '📡 تنظیمات کانال', 'callback_data' => 'channel_settings'],
        ['text' => '💬 ارسال پیام', 'callback_data' => 'send_message'],
        ['text' => '👨‍💼 مدیریت ادمین‌ها', 'callback_data' => 'admins'],
        ['text' => '🎙️ ارسال به چنل', 'callback_data' => 'send_channel'],
        ['text' => '🎯 مدیریت تبلیغات', 'callback_data' => 'advertisement'],
        ['text' => '🎛️ تنظیمات', 'callback_data' => 'settings'],
        ['text' => '🎁 مدیریت کد جایزه', 'callback_data' => 'promo_codes'],
        ['text' => '🤖 ربات بک آپ', 'callback_data' => 'backup_bot'],
        ['text' => '👤 حالت کاربر', 'callback_data' => 'toggle_user_mode'],
    ];
    
    // Paginate items (6 items per page = 3 rows of 2 columns)
    $items_per_page = 6;
    $total_pages = ceil(count($all_items) / $items_per_page);
    $page = max(1, min($page, $total_pages));
    $offset = ($page - 1) * $items_per_page;
    $page_items = array_slice($all_items, $offset, $items_per_page);
    
    // Build keyboard rows (2 columns per row)
    $keyboard_rows = [];
    for ($i = 0; $i < count($page_items); $i += 2) {
        $row = [$page_items[$i]];
        if (isset($page_items[$i + 1])) {
            $row[] = $page_items[$i + 1];
        }
        $keyboard_rows[] = $row;
    }
    
    // Add pagination buttons if needed
    if ($total_pages > 1) {
        $pagination_row = [];
        if ($page > 1) {
            $pagination_row[] = ['text' => '◀️ قبلی', 'callback_data' => 'main_page_' . ($page - 1)];
        }
        $pagination_row[] = ['text' => "📄 {$page}/{$total_pages}", 'callback_data' => 'main_page_' . $page];
        if ($page < $total_pages) {
            $pagination_row[] = ['text' => '▶️ بعدی', 'callback_data' => 'main_page_' . ($page + 1)];
        }
        $keyboard_rows[] = $pagination_row;
    }
    
    // Add home button
    $keyboard_rows[] = [['text' => '🏠 منوی اصلی', 'callback_data' => 'start']];
    
    $keyboards = [
        'main' => [
            'inline_keyboard' => $keyboard_rows
        ],

        'settings' => [
            'inline_keyboard' => [
                [
                    ['text' => '⚙️ تنظیمات پیشرفته', 'callback_data' => 'advanced_settings']
                ],
                [
                    ['text' => '🔄 لیست امکانات', 'callback_data' => 'features_list']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],
        
        'features_list' => [
            'inline_keyboard' => [
                // This will be generated dynamically in displaySettings
            ]
        ],
        
        'advanced_settings' => [
            'inline_keyboard' => [
                [
                    ['text' => '⭐ نرخ Stars', 'callback_data' => 'set_stars_rate'],
                    ['text' => '🎁 امتیاز معرف', 'callback_data' => 'set_referral_points']
                ],
                [
                    ['text' => '🎁 امتیاز رفرال چند سطحی', 'callback_data' => 'set_referral_multilevel_points']
                ],
                [
                    ['text' => '🎲 تنظیمات بازی', 'callback_data' => 'gambling_settings']
                ],
                [
                    ['text' => '📢 متن Forced Join', 'callback_data' => 'set_forced_join_text']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'settings']
                ]
            ]
        ],
        
        'gambling_settings' => [
            'inline_keyboard' => [
                [
                    ['text' => '💰 حداقل شرط', 'callback_data' => 'set_gambling_min_bet'],
                    ['text' => '💰 حداکثر شرط', 'callback_data' => 'set_gambling_max_bet']
                ],
                [
                    ['text' => '🎯 نرخ برد', 'callback_data' => 'set_gambling_multiplier']
                ],
                [
                    ['text' => '📅 محدودیت روزانه', 'callback_data' => 'set_gambling_daily_limit'],
                    ['text' => '⏱️ زمان انتظار', 'callback_data' => 'set_gambling_cooldown']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'advanced_settings']
                ]
            ]
        ],

        'admins' => [
            'inline_keyboard' => [
                [
                    ['text' => '✨ افزودن ادمین', 'callback_data' => 'add_admin'],
                    ['text' => '🗑️ حذف ادمین', 'callback_data' => 'remove_admin']
                ],
                [
                    ['text' => '📑 لیست ادمین‌ها', 'callback_data' => 'list_admins']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],

        'channel_settings' => [
            'inline_keyboard' => [
                [
                    ['text' => '✨ افزودن کانال', 'callback_data' => 'add_channel'],
                    ['text' => '🗑️ حذف کانال', 'callback_data' => 'remove_channel']
                ],
                [
                    ['text' => '📑 لیست کانال‌ها', 'callback_data' => 'list_channels']
                ],
                [
                    ['text' => '💬 کانال‌های ری‌اکشن', 'callback_data' => 'reaction_channels']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],
        
        'reaction_channels' => [
            'inline_keyboard' => [
                [
                    ['text' => '✨ افزودن کانال ری‌اکشن', 'callback_data' => 'add_reaction_channel'],
                    ['text' => '🗑️ حذف کانال ری‌اکشن', 'callback_data' => 'remove_reaction_channel']
                ],
                [
                    ['text' => '📑 لیست کانال‌های ری‌اکشن', 'callback_data' => 'list_reaction_channels']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'channel_settings']
                ]
            ]
        ],
        
        'user_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points'],
                    ['text' => '🎁 لینک معرف', 'callback_data' => 'my_referral']
                ],
                [
                    ['text' => '🎰 اسپین روزانه', 'callback_data' => 'daily_spin']
                ],
                [
                    ['text' => '🎫 استفاده از کد', 'callback_data' => 'use_promo_code']
                ],
                [
                    ['text' => '🎲 بازی و شرط‌بندی', 'callback_data' => 'gambling']
                ],
                [
                    ['text' => '⬇️ دانلود فایل', 'callback_data' => 'download_file'],
                    ['text' => '📥 دانلود شده‌ها', 'callback_data' => 'my_downloads']
                ]
            ]
        ],
        
        'user_menu_with_exit' => [
            'inline_keyboard' => [
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points'],
                    ['text' => '🎁 لینک معرف', 'callback_data' => 'my_referral']
                ],
                [
                    ['text' => '🎰 اسپین روزانه', 'callback_data' => 'daily_spin']
                ],
                [
                    ['text' => '🎫 استفاده از کد', 'callback_data' => 'use_promo_code']
                ],
                [
                    ['text' => '🎲 بازی و شرط‌بندی', 'callback_data' => 'gambling']
                ],
                [
                    ['text' => '⬇️ دانلود فایل', 'callback_data' => 'download_file'],
                    ['text' => '📥 دانلود شده‌ها', 'callback_data' => 'my_downloads']
                ],
                [
                    ['text' => '👨‍💼 بازگشت به حالت ادمین', 'callback_data' => 'toggle_user_mode']
                ]
            ]
        ],
        
        'user_spin_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ]
            ]
        ],
        
        'user_spin_menu_with_exit' => [
            'inline_keyboard' => [
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ],
                [
                    ['text' => '👨‍💼 بازگشت به حالت ادمین', 'callback_data' => 'toggle_user_mode']
                ]
            ]
        ],
        
        'user_promo_code_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ]
            ]
        ],
        
        'user_promo_code_menu_with_exit' => [
            'inline_keyboard' => [
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ],
                [
                    ['text' => '👨‍💼 بازگشت به حالت ادمین', 'callback_data' => 'toggle_user_mode']
                ]
            ]
        ],
        
        'user_points_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '⬇️ دانلود فایل', 'callback_data' => 'download_file']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ]
            ]
        ],
        
        'user_points_menu_with_exit' => [
            'inline_keyboard' => [
                [
                    ['text' => '⬇️ دانلود فایل', 'callback_data' => 'download_file']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ],
                [
                    ['text' => '👨‍💼 بازگشت به حالت ادمین', 'callback_data' => 'toggle_user_mode']
                ]
            ]
        ],
        
        'user_referral_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '🌳 درخت معرف', 'callback_data' => 'show_referral_tree']
                ],
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ]
            ]
        ],
        
        'user_referral_menu_with_exit' => [
            'inline_keyboard' => [
                [
                    ['text' => '🌳 درخت معرف', 'callback_data' => 'show_referral_tree']
                ],
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ],
                [
                    ['text' => '👨‍💼 بازگشت به حالت ادمین', 'callback_data' => 'toggle_user_mode']
                ]
            ]
        ],
        
        'user_download_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '⭐ فایل‌های پیشنهادی', 'callback_data' => 'recommended_files']
                ],
                [
                    ['text' => '📑 لیست فایل‌ها', 'callback_data' => 'file_sorting_menu']
                ],
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ]
            ]
        ],
        
        'user_download_menu_with_exit' => [
            'inline_keyboard' => [
                [
                    ['text' => '⭐ فایل‌های پیشنهادی', 'callback_data' => 'recommended_files']
                ],
                [
                    ['text' => '📑 لیست فایل‌ها', 'callback_data' => 'file_sorting_menu']
                ],
                [
                    ['text' => '💎 امتیاز من', 'callback_data' => 'my_points']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ],
                [
                    ['text' => '👨‍💼 بازگشت به حالت ادمین', 'callback_data' => 'toggle_user_mode']
                ]
            ]
        ],
        
        'file_sorting_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '🔥 محبوبیت', 'callback_data' => 'sort_files_popular_page_1'],
                    ['text' => '📅 تاریخ', 'callback_data' => 'sort_files_date_page_1']
                ],
                [
                    ['text' => '📊 تعداد دانلود', 'callback_data' => 'sort_files_downloads_page_1'],
                    ['text' => '⭐ پیشنهادی', 'callback_data' => 'recommended_files']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'download_file']
                ]
            ]
        ],
        
        'user_mode_exit' => [
            'inline_keyboard' => [
                [
                    ['text' => '👨‍💼 خروج از حالت کاربر', 'callback_data' => 'toggle_user_mode']
                ]
            ]
        ],
        
        'back_only' => [
            'inline_keyboard' => [
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => isset($params['back_to']) ? $params['back_to'] : 'back_main']
                ]
            ]
        ],
        
        'block_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '🔎 جستجوی کاربر', 'callback_data' => 'search_user']
                ],
                [
                    ['text' => '💎 مدیریت امتیاز', 'callback_data' => 'point_management']
                ],
                [
                    ['text' => '🚫 بلاک کاربر', 'callback_data' => 'block_user'],
                    ['text' => '✅ آنبلاک کاربر', 'callback_data' => 'unblock_user']
                ],
                [
                    ['text' => '👑 VIP کردن کاربر', 'callback_data' => 'set_vip'],
                    ['text' => '❌ حذف VIP', 'callback_data' => 'remove_vip']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],
        
        'point_management' => [
            'inline_keyboard' => [
                [
                    ['text' => '➕ افزودن امتیاز', 'callback_data' => 'add_points'],
                    ['text' => '➖ کسر امتیاز', 'callback_data' => 'deduct_points']
                ],
                [
                    ['text' => '🔢 تنظیم امتیاز', 'callback_data' => 'set_points']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'block']
                ]
            ]
        ],
        
        'user_info_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '➕ افزودن امتیاز', 'callback_data' => 'add_points_user'],
                    ['text' => '➖ کسر امتیاز', 'callback_data' => 'deduct_points_user']
                ],
                [
                    ['text' => '🔢 تنظیم امتیاز', 'callback_data' => 'set_points_user']
                ],
                [
                    ['text' => '🚫 بلاک', 'callback_data' => 'block_user_info'],
                    ['text' => '✅ آنبلاک', 'callback_data' => 'unblock_user_info']
                ],
                [
                    ['text' => '👑 VIP', 'callback_data' => 'set_vip_user'],
                    ['text' => '❌ حذف VIP', 'callback_data' => 'remove_vip_user']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'block']
                ]
            ]
        ],
        
        'send_message' => [
            'inline_keyboard' => [
                [
                    ['text' => '📨 Broadcast عادی', 'callback_data' => 'broadcast_normal'],
                    ['text' => '📤 Broadcast Forward', 'callback_data' => 'broadcast_forward']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],
        
        'advertisement' => [
            'inline_keyboard' => [
                [
                    ['text' => '✨ افزودن تبلیغ', 'callback_data' => 'add_advertisement'],
                    ['text' => '🗑️ حذف تبلیغ', 'callback_data' => 'remove_advertisement']
                ],
                [
                    ['text' => '📑 لیست تبلیغات', 'callback_data' => 'list_advertisements']
                ],
                [
                    ['text' => '📢 کانال‌های تبلیغاتی', 'callback_data' => 'advertisement_channels']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],
        
        'advertisement_channels' => [
            'inline_keyboard' => [
                [
                    ['text' => '➕ افزودن کانال', 'callback_data' => 'add_ad_channel'],
                    ['text' => '🗑️ حذف کانال', 'callback_data' => 'remove_ad_channel']
                ],
                [
                    ['text' => '📑 لیست کانال‌ها', 'callback_data' => 'list_ad_channels']
                ],
                [
                    ['text' => '⚡ فعال/غیرفعال', 'callback_data' => 'toggle_ad_enabled']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'advertisement']
                ]
            ]
        ],
        
        'media' => [
            'inline_keyboard' => [
                [
                    ['text' => '🚀 آپلود فایل', 'callback_data' => 'upload'],
                    ['text' => '📑 لیست مدیا', 'callback_data' => 'list_media']
                ],
                [
                    ['text' => '⏱️ تایم حذف', 'callback_data' => 'delete_time'],
                    ['text' => '⚙️ تنظیمات مدیا', 'callback_data' => 'media_settings']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],
        
        'media_settings' => [
            'inline_keyboard' => [
                [
                    ['text' => 'ℹ️ اطلاعات مدیا', 'callback_data' => 'media_info']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'media']
                ]
            ]
        ],
        
        'promo_codes' => [
            'inline_keyboard' => [
                [
                    ['text' => '✨ افزودن کد جایزه', 'callback_data' => 'add_promo_gift'],
                    ['text' => '💰 افزودن کد تخفیف', 'callback_data' => 'add_promo_discount']
                ],
                [
                    ['text' => '⭐ افزودن کد سکه', 'callback_data' => 'add_promo_coin'],
                    ['text' => '📑 لیست کدها', 'callback_data' => 'list_promo_codes']
                ],
                [
                    ['text' => '🗑️ حذف کد', 'callback_data' => 'delete_promo_code']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'back_main']
                ]
            ]
        ],
        
        'gambling_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '🎯 حدس عدد', 'callback_data' => 'gambling_number_guess'],
                    ['text' => '🪙 سکه', 'callback_data' => 'gambling_coin_flip']
                ],
                [
                    ['text' => '🎲 تاس', 'callback_data' => 'gambling_dice_roll']
                ],
                [
                    ['text' => '📊 آمار بازی', 'callback_data' => 'gambling_stats']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'start']
                ]
            ]
        ],
        
        'gambling_bet_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '1 امتیاز', 'callback_data' => 'gambling_bet_1'],
                    ['text' => '5 امتیاز', 'callback_data' => 'gambling_bet_5'],
                    ['text' => '10 امتیاز', 'callback_data' => 'gambling_bet_10']
                ],
                [
                    ['text' => '20 امتیاز', 'callback_data' => 'gambling_bet_20'],
                    ['text' => '50 امتیاز', 'callback_data' => 'gambling_bet_50'],
                    ['text' => '100 امتیاز', 'callback_data' => 'gambling_bet_100']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'gambling']
                ]
            ]
        ],
        
        'gambling_number_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '1', 'callback_data' => 'gambling_number_1'],
                    ['text' => '2', 'callback_data' => 'gambling_number_2'],
                    ['text' => '3', 'callback_data' => 'gambling_number_3']
                ],
                [
                    ['text' => '4', 'callback_data' => 'gambling_number_4'],
                    ['text' => '5', 'callback_data' => 'gambling_number_5'],
                    ['text' => '6', 'callback_data' => 'gambling_number_6']
                ],
                [
                    ['text' => '7', 'callback_data' => 'gambling_number_7'],
                    ['text' => '8', 'callback_data' => 'gambling_number_8'],
                    ['text' => '9', 'callback_data' => 'gambling_number_9']
                ],
                [
                    ['text' => '10', 'callback_data' => 'gambling_number_10']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'gambling']
                ]
            ]
        ],
        
        'gambling_dice_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '1', 'callback_data' => 'gambling_dice_1'],
                    ['text' => '2', 'callback_data' => 'gambling_dice_2'],
                    ['text' => '3', 'callback_data' => 'gambling_dice_3']
                ],
                [
                    ['text' => '4', 'callback_data' => 'gambling_dice_4'],
                    ['text' => '5', 'callback_data' => 'gambling_dice_5'],
                    ['text' => '6', 'callback_data' => 'gambling_dice_6']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'gambling']
                ]
            ]
        ],
        
        'gambling_coin_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '🪙 شیر', 'callback_data' => 'gambling_coin_heads'],
                    ['text' => '🪙 خط', 'callback_data' => 'gambling_coin_tails']
                ],
                [
                    ['text' => '⬅️ بازگشت', 'callback_data' => 'gambling']
                ]
            ]
        ],
        
        'gambling_stats_menu' => [
            'inline_keyboard' => [
                [
                    ['text' => '🎲 بازی جدید', 'callback_data' => 'gambling']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ]
            ]
        ],
        
        'gambling_stats_menu_with_exit' => [
            'inline_keyboard' => [
                [
                    ['text' => '🎲 بازی جدید', 'callback_data' => 'gambling']
                ],
                [
                    ['text' => '🏠 منوی اصلی', 'callback_data' => 'start']
                ],
                [
                    ['text' => '👨‍💼 بازگشت به حالت ادمین', 'callback_data' => 'toggle_user_mode']
                ]
            ]
        ]
    ];

    // If keyboard type exists, return it, otherwise return main keyboard
    return $keyboards[$type] ?? $keyboards['main'];
}

/**
 * Get paginated keyboard for main menu
 * @param int $page Page number (1-based)
 * @return array Keyboard array
 */
function getMainKeyboardPaginated(int $page = 1): array {
    return getInlineKeyboard('main', $page);
}