<?php
declare(strict_types=1);

if (!function_exists('component_themes')) {
    function component_themes(): array
    {
        return [
            'classic' => [
                'label' => 'تم کلاسیک 🧭',
                'description' => 'متن رسمی و استاندارد.',
                'prefix' => '🎬',
                'suffix' => '',
                'aliases' => ['تم کلاسیک', 'کلاسیک'],
            ],
            'luxury' => [
                'label' => 'تم لاکچری 💎',
                'description' => 'استایل لاکچری با ایموجی درخشان.',
                'prefix' => '💎',
                'suffix' => '💎',
                'aliases' => ['تم لاکچری', 'لاکچری', 'تم لاکس'],
            ],
            'street' => [
                'label' => 'تم لاتی 😈',
                'description' => 'لحن خودمونی و خیابونی.',
                'prefix' => '😈',
                'suffix' => '🔥',
                'aliases' => ['تم لاتی', 'لاتی', 'خیابونی'],
            ],
            'fun' => [
                'label' => 'تم فان 🎉',
                'description' => 'شوخ و پرانرژی.',
                'prefix' => '🎉',
                'suffix' => '✨',
                'aliases' => ['تم فان', 'فان', 'شوخ'],
            ],
            'savage' => [
                'label' => 'تم بی‌ادب 🤬',
                'description' => 'شوخی تند و بی‌پرده برای مخاطب بزرگسال.',
                'prefix' => '🤬',
                'suffix' => '💢',
                'aliases' => ['بی‌ادب', 'بی ادب', 'سوسکی', 'خراب'],
            ],
        ];
    }
}

if (!function_exists('component_keyboard_types')) {
    function component_keyboard_types(): array
    {
        return [
            'reply' => [
                'label' => 'کیبورد معمولی',
                'description' => 'دکمه‌ها پایین صفحه چت ظاهر می‌شوند.',
                'aliases' => ['کیبورد معمولی', 'reply', 'معمولی'],
            ],
            'inline' => [
                'label' => 'کیبورد شیشه‌ای',
                'description' => 'دکمه‌ها داخل همان پیام نمایش داده می‌شوند.',
                'aliases' => ['کیبورد شیشه‌ای', 'inline', 'شیشه‌ای', 'شیشه اي'],
            ],
        ];
    }
}

if (!function_exists('component_actions')) {
    function component_actions(bool $includeAdmin = false): array
    {
        $actions = [
            [
                'command' => '/latest',
                'reply_label' => '/latest 📥',
                'inline_label' => '📥 آخرین‌ها',
                'action' => 'latest',
            ],
            [
                'command' => '/status',
                'reply_label' => '/status 📊',
                'inline_label' => '📊 وضعیت',
                'action' => 'status',
            ],
            [
                'command' => '/settings',
                'reply_label' => '/settings ⚙️',
                'inline_label' => '⚙️ تنظیمات',
                'action' => 'settings',
            ],
        ];

        if ($includeAdmin) {
            $actions[] = [
                'command' => '/upload',
                'reply_label' => '/upload ⬆️',
                'inline_label' => '⬆️ آپلود',
                'action' => 'upload',
            ];
        }

        return $actions;
    }
}

