<?php
declare(strict_types=1);

require_once __DIR__ . '/components.php';

if (!function_exists('kb_actions')) {
    function kb_actions(bool $isAdmin): array
    {
        return component_actions($isAdmin);
    }
}

if (!function_exists('kb_reply_default')) {
    function kb_reply_default(array $actions): array
    {
        $rows = [];
        foreach (array_chunk($actions, 2) as $chunk) {
            $rows[] = array_map(static fn(array $action): string => $action['reply_label'], $chunk);
        }

        return [
            'keyboard' => $rows,
            'resize_keyboard' => true,
            'one_time_keyboard' => false,
        ];
    }
}

if (!function_exists('kb_inline_default')) {
    function kb_inline_default(array $actions): array
    {
        $rows = [];
        foreach (array_chunk($actions, 2) as $chunk) {
            $rows[] = array_map(static function (array $action): array {
                return [
                    'text' => $action['inline_label'],
                    'callback_data' => 'action:' . $action['action'],
                ];
            }, $chunk);
        }

        return ['inline_keyboard' => $rows];
    }
}

if (!function_exists('kb_build_default')) {
    function kb_build_default(array $user, bool $isAdmin): array
    {
        $actions = kb_actions($isAdmin);
        $type = $user['keyboard_type'] ?? 'reply';

        return $type === 'inline'
            ? kb_inline_default($actions)
            : kb_reply_default($actions);
    }
}

if (!function_exists('kb_settings_inline')) {
    function kb_settings_inline(array $user, ?array $themes = null, ?array $keyboardTypes = null): array
    {
        $themes ??= component_themes();
        $keyboardTypes ??= component_keyboard_types();

        $currentTheme = $user['theme'] ?? 'classic';
        $currentKeyboard = $user['keyboard_type'] ?? 'reply';

        $themeButtons = [];
        foreach ($themes as $key => $info) {
            $label = $info['label'];
            if ($key === $currentTheme) {
                $label = '✅ ' . $label;
            }
            $themeButtons[] = [
                'text' => $label,
                'callback_data' => 'theme:' . $key,
            ];
        }

        $keyboard = array_chunk($themeButtons, 2);
        $keyboard[] = [
            [
                'text' => ($currentKeyboard === 'reply' ? '✅ ' : '') . ($keyboardTypes['reply']['label'] ?? 'Reply'),
                'callback_data' => 'keyboard:reply',
            ],
            [
                'text' => ($currentKeyboard === 'inline' ? '✅ ' : '') . ($keyboardTypes['inline']['label'] ?? 'Inline'),
                'callback_data' => 'keyboard:inline',
            ],
        ];

        return ['inline_keyboard' => $keyboard];
    }
}

