<?php
declare(strict_types=1);

require __DIR__ . '/../src/helpers.php';
require __DIR__ . '/../src/Core/Database.php';
require __DIR__ . '/../src/Core/TelegramClient.php';
require __DIR__ . '/../src/Core/Router.php';
require __DIR__ . '/../src/Repositories/MediaRepository.php';
require __DIR__ . '/../src/Repositories/UserRepository.php';
require __DIR__ . '/../src/Repositories/ChannelRepository.php';
require __DIR__ . '/../src/Services/MediaService.php';
require __DIR__ . '/../src/Services/SubscriptionService.php';
require __DIR__ . '/../src/Services/ChannelService.php';
require __DIR__ . '/../src/Services/SettingsService.php';
require __DIR__ . '/../src/Bot/CommandController.php';

$appConfig = config('app');
$telegram = new TelegramClient($appConfig['bot_token']);
$database = new Database();
$mediaRepository = new MediaRepository($database);
$userRepository = new UserRepository($database);
$channelRepository = new ChannelRepository($database);
$subscriptionService = new SubscriptionService($userRepository);
$channelService = new ChannelService($channelRepository, $appConfig);
$settingsService = new SettingsService($userRepository);
$mediaService = new MediaService($mediaRepository, $telegram, $channelService, $appConfig);
$controller = new CommandController(
    $telegram,
    $mediaService,
    $subscriptionService,
    $channelService,
    $settingsService,
    $database,
    $appConfig
);

$router = new Router();
$router->register('/start', [$controller, 'start']);
$router->register('/upload', [$controller, 'promptUpload']);
$router->register('/status', [$controller, 'status']);
$router->register('/latest', [$controller, 'latest']);
$router->register('/get', [$controller, 'getMedia']);
$router->register('/channels', [$controller, 'channels']);
$router->register('/addchannel', [$controller, 'addChannel']);
$router->register('/setchannel', [$controller, 'setDefaultChannel']);
$router->register('/publish', [$controller, 'publishMedia']);
$router->register('/settings', [$controller, 'settings']);
$router->register('/theme', [$controller, 'changeTheme']);
$router->register('/keyboard', [$controller, 'changeKeyboard']);
$router->register('/crdb', [$controller, 'createDatabase']);
$router->register('/resdb', [$controller, 'resetDatabase']);
$router->register('*', [$controller, 'handleDefault']);

$router->registerCallback('theme:', [$controller, 'handleThemeCallback']);
$router->registerCallback('keyboard:', [$controller, 'handleKeyboardCallback']);
$router->registerCallback('action:', [$controller, 'handleActionCallback']);

$input = file_get_contents('php://input');
if ($appConfig['debug']) {
    logger('Incoming update: ' . $input);
}
$update = json_decode($input ?: '[]', true);
if (!is_array($update)) {
    http_response_code(400);
    exit('invalid update');
}

$router->dispatch($update);

echo 'ok';

