<?php
declare(strict_types=1);

final class MediaRepository
{
    public function __construct(private readonly Database $db)
    {
    }

    public function store(array $data): int
    {
        $sql = 'INSERT INTO media (file_id, title, description, cover, owner_id, channel_id) 
                VALUES (:file_id, :title, :description, :cover, :owner_id, :channel_id)';
        $this->db->query($sql, [
            ':file_id' => $data['file_id'],
            ':title' => $data['title'],
            ':description' => $data['description'],
            ':cover' => $data['cover'],
            ':owner_id' => $data['owner_id'],
            ':channel_id' => $data['channel_id'],
        ]);
        return $this->db->lastInsertId();
    }

    public function latest(int $limit = 10): array
    {
        $limit = max(1, $limit);
        $sql = 'SELECT * FROM media ORDER BY id DESC LIMIT ' . (int)$limit;
        return $this->db->fetchAll($sql);
    }

    public function find(int $mediaId): ?array
    {
        return $this->db->fetch('SELECT * FROM media WHERE id = :id', [':id' => $mediaId]);
    }
}

