﻿<?php
declare(strict_types=1);

function project_path(string $path = ''): string
{
    $base = realpath(__DIR__ . '/..') ?: __DIR__ . '/..';
    return $path === '' ? $base : $base . DIRECTORY_SEPARATOR . str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $path);
}

function config(string $name): array
{
    $path = project_path('config/' . $name . '.php');
    if (!is_file($path)) {
        throw new RuntimeException('Config file not found: ' . $name);
    }
    return require $path;
}

function logger(string $message): void
{
    $logPath = project_path('storage/logs/bot.log');
    $line = sprintf("[%s] %s%s", date('Y-m-d H:i:s'), $message, PHP_EOL);
    file_put_contents($logPath, $line, FILE_APPEND);
}
