-- جدول کانال‌های اجباری برای جوین
CREATE TABLE IF NOT EXISTS forced_join_channels (
    id INT AUTO_INCREMENT PRIMARY KEY,
    channel_username VARCHAR(255) NOT NULL UNIQUE, -- مثال: @channel_name یا -1001234567890
    channel_type VARCHAR(32) NOT NULL DEFAULT 'channel', -- channel|group|supergroup
    enabled TINYINT(1) NOT NULL DEFAULT 1,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_enabled (enabled),
    INDEX idx_channel_username (channel_username)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

