<?php

declare(strict_types=1);

namespace Bot\Domain\Entity;

final class AnalyticsEvent
{
    public function __construct(
        private readonly int $id,
        private readonly string $type, // download|click|join_converted|payment
        private readonly ?int $userId,
        private readonly ?int $mediaId,
        private readonly ?int $paymentId,
        private readonly \DateTimeImmutable $occurredAt,
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getUserId(): ?int
    {
        return $this->userId;
    }

    public function getMediaId(): ?int
    {
        return $this->mediaId;
    }

    public function getPaymentId(): ?int
    {
        return $this->paymentId;
    }

    public function getOccurredAt(): \DateTimeImmutable
    {
        return $this->occurredAt;
    }
}


