<?php

declare(strict_types=1);

namespace Bot\Domain\Entity;

final class Folder
{
    public function __construct(
        private readonly int $id,
        private readonly int $ownerAdminId,
        private string $name,
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getOwnerAdminId(): int
    {
        return $this->ownerAdminId;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function rename(string $name): void
    {
        $this->name = $name;
    }
}


