<?php

declare(strict_types=1);

namespace Bot\Domain\Entity;

final class ForcedJoinChannel
{
    public function __construct(
        private readonly int $id,
        private string $channelUsername, // @channel_name یا -1001234567890
        private string $channelType, // channel|group|supergroup
        private bool $enabled = true,
        private ?string $inviteLink = null, // لینک دعوت برای کانال‌های chat_id
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getChannelUsername(): string
    {
        return $this->channelUsername;
    }

    public function setChannelUsername(string $channelUsername): void
    {
        $this->channelUsername = $channelUsername;
    }

    public function getChannelType(): string
    {
        return $this->channelType;
    }

    public function setChannelType(string $channelType): void
    {
        $this->channelType = $channelType;
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    public function toggle(bool $enabled): void
    {
        $this->enabled = $enabled;
    }

    public function getInviteLink(): ?string
    {
        return $this->inviteLink;
    }

    public function setInviteLink(?string $inviteLink): void
    {
        $this->inviteLink = $inviteLink;
    }
}

