<?php

declare(strict_types=1);

namespace Bot\Domain\Entity;

final class User
{
    public function __construct(
        private readonly int $id,
        private readonly int $telegramId,
        private string $mode = 'free', // free|premium
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getTelegramId(): int
    {
        return $this->telegramId;
    }

    public function getMode(): string
    {
        return $this->mode;
    }

    public function upgradeToPremium(): void
    {
        $this->mode = 'premium';
    }
}


