<?php

declare(strict_types=1);

namespace Bot\Domain\Repository;

use Bot\Domain\Entity\ForcedJoinChannel;

interface ForcedJoinChannelRepositoryInterface
{
    /**
     * @return ForcedJoinChannel[]
     */
    public function findAll(): array;

    /**
     * @return ForcedJoinChannel[]
     */
    public function findEnabled(): array;

    public function findByChannelUsername(string $channelUsername): ?ForcedJoinChannel;

    public function findById(int $id): ?ForcedJoinChannel;

    public function save(ForcedJoinChannel $channel): void;

    public function delete(int $id): void;
}

