<?php

declare(strict_types=1);

namespace Bot\Domain\Repository;

use Bot\Domain\Entity\Payment;

interface PaymentRepositoryInterface
{
    public function findById(int $id): ?Payment;

    public function findByPayload(string $payload): ?Payment;

    public function findByExternalId(string $externalId): ?Payment;

    public function save(Payment $payment): void;
}



