#!/bin/bash
# -*- coding: utf-8 -*-

# Script to stop Telegram Bot
# Usage: ./stop.sh

export LANG=en_US.UTF-8
export LC_ALL=en_US.UTF-8

cd "$(dirname "$0")"

PID_FILE="bot.pid"

# تابع برای kill کردن همه process های ربات
kill_all_bot_processes() {
    echo "جستجوی همه process های ربات..."
    
    # پیدا کردن همه process های مرتبط با public/index.php
    PIDS=$(ps aux | grep -E "[p]hp.*public/index\.php" | awk '{print $2}')
    
    if [ -z "$PIDS" ]; then
        echo "هیچ process رباتی یافت نشد."
        return 0
    fi
    
    echo "یافت شد: $PIDS"
    
    for PID in $PIDS; do
        echo "در حال متوقف کردن process با PID: $PID"
        kill "$PID" 2>/dev/null
    done
    
    # صبر برای توقف
    sleep 2
    
    # Force kill اگر هنوز در حال اجرا هستند
    REMAINING=$(ps aux | grep -E "[p]hp.*public/index\.php" | awk '{print $2}')
    if [ -n "$REMAINING" ]; then
        echo "Force killing باقی‌مانده process ها..."
        for PID in $REMAINING; do
            kill -9 "$PID" 2>/dev/null
        done
        sleep 1
    fi
    
    # بررسی نهایی
    FINAL_CHECK=$(ps aux | grep -E "[p]hp.*public/index\.php" | awk '{print $2}')
    if [ -z "$FINAL_CHECK" ]; then
        echo "✅ همه process های ربات متوقف شدند."
        rm -f "$PID_FILE"
        return 0
    else
        echo "⚠️ برخی process ها هنوز در حال اجرا هستند: $FINAL_CHECK"
        return 1
    fi
}

# اگر PID file وجود دارد، ابتدا آن را امتحان کنیم
if [ -f "$PID_FILE" ]; then
    PID=$(cat "$PID_FILE")
    
    if ps -p "$PID" > /dev/null 2>&1; then
        echo "Stopping bot (PID: $PID)..."
        kill "$PID"
        sleep 2
        
        if ps -p "$PID" > /dev/null 2>&1; then
            echo "Warning: Bot did not stop. Force killing..."
            kill -9 "$PID"
            sleep 1
        fi
        
        if ! ps -p "$PID" > /dev/null 2>&1; then
            rm -f "$PID_FILE"
            echo "Bot stopped successfully."
        fi
    else
        echo "Warning: Process with PID $PID not found."
        rm -f "$PID_FILE"
    fi
fi

# kill کردن همه process های باقی‌مانده
kill_all_bot_processes

# kill کردن forever script اگر در حال اجراست
FOREVER_PID_FILE="bot.forever.pid"
if [ -f "$FOREVER_PID_FILE" ]; then
    FOREVER_PID=$(cat "$FOREVER_PID_FILE")
    if ps -p "$FOREVER_PID" > /dev/null 2>&1; then
        echo "Stopping forever script (PID: $FOREVER_PID)..."
        kill "$FOREVER_PID" 2>/dev/null
        sleep 1
        if ps -p "$FOREVER_PID" > /dev/null 2>&1; then
            kill -9 "$FOREVER_PID" 2>/dev/null
        fi
    fi
    rm -f "$FOREVER_PID_FILE"
fi

