-- Minimal relational schema for Telegram uploader bot core
-- Users (bot users)
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    telegram_id BIGINT NOT NULL UNIQUE,
    mode VARCHAR(16) NOT NULL DEFAULT 'free' -- free|premium
);

-- Admins (bot admins/owners)
CREATE TABLE admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    telegram_id BIGINT NOT NULL UNIQUE,
    is_owner TINYINT(1) NOT NULL DEFAULT 0
);

-- Folders for organizing media by admin
CREATE TABLE folders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    owner_admin_id INT NOT NULL,
    name VARCHAR(255) NOT NULL,
    CONSTRAINT fk_folders_admin
        FOREIGN KEY (owner_admin_id) REFERENCES admins(id)
            ON DELETE CASCADE
);

-- Media items uploaded by admins
CREATE TABLE media (
    id INT AUTO_INCREMENT PRIMARY KEY,
    folder_id INT NOT NULL,
    owner_admin_id INT NOT NULL,
    telegram_file_id VARCHAR(255) NOT NULL,
    type VARCHAR(32) NOT NULL, -- photo|video|document|...
    thumbnail_file_id VARCHAR(255) NULL,
    thumbnail_enabled TINYINT(1) NOT NULL DEFAULT 1,
    caption TEXT NULL,
    auto_delete_seconds INT NULL,
    link_in_caption_enabled TINYINT(1) NOT NULL DEFAULT 1,
    CONSTRAINT fk_media_folder
        FOREIGN KEY (folder_id) REFERENCES folders(id)
            ON DELETE CASCADE,
    CONSTRAINT fk_media_admin
        FOREIGN KEY (owner_admin_id) REFERENCES admins(id)
            ON DELETE CASCADE
);

-- Payments for upgrading users or buying quotas
CREATE TABLE payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    gateway VARCHAR(32) NOT NULL, -- telegram_stars|nextpay|zarinpal
    amount INT NOT NULL,
    status VARCHAR(16) NOT NULL DEFAULT 'pending', -- pending|success|failed
    external_id VARCHAR(191) NULL,
    payload TEXT NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT fk_payments_user
        FOREIGN KEY (user_id) REFERENCES users(id)
            ON DELETE CASCADE
);

-- Ads configuration
CREATE TABLE ads (
    id INT AUTO_INCREMENT PRIMARY KEY,
    owner_admin_id INT NOT NULL,
    text TEXT NOT NULL,
    banner_url VARCHAR(255) NULL,
    frequency INT NOT NULL DEFAULT 1, -- show ad every N messages
    enabled TINYINT(1) NOT NULL DEFAULT 1,
    CONSTRAINT fk_ads_admin
        FOREIGN KEY (owner_admin_id) REFERENCES admins(id)
            ON DELETE CASCADE
);

-- Analytics events (downloads, clicks, joins, payments, ...)
CREATE TABLE analytics_events (
    id INT AUTO_INCREMENT PRIMARY KEY,
    type VARCHAR(32) NOT NULL, -- download|click|join_converted|payment
    user_id INT NULL,
    media_id INT NULL,
    payment_id INT NULL,
    occurred_at DATETIME NOT NULL,
    CONSTRAINT fk_analytics_user
        FOREIGN KEY (user_id) REFERENCES users(id)
            ON DELETE SET NULL,
    CONSTRAINT fk_analytics_media
        FOREIGN KEY (media_id) REFERENCES media(id)
            ON DELETE SET NULL,
    CONSTRAINT fk_analytics_payment
        FOREIGN KEY (payment_id) REFERENCES payments(id)
            ON DELETE SET NULL
);


