<?php

declare(strict_types=1);

namespace Bot\Domain\Service;

/**
 * Domain-level abstraction for forced-join logic.
 *
 * Infrastructure layer (Natgram / HTTP) is responsible for
 * actually checking membership in channels and passing results here.
 */
final class ForcedJoinService
{
    /**
     * For now, this is a minimal placeholder that can be extended later
     * with more detailed policies (per-channel, per-media, etc.).
     */
    public function isUserAllowedToDownload(bool $hasJoinedRequiredChannels): bool
    {
        return $hasJoinedRequiredChannels;
    }
}



