<?php

declare(strict_types=1);

namespace Bot\Domain\Service;

use Bot\Domain\Entity\Media;
use Bot\Domain\Repository\MediaRepositoryInterface;

final class MediaService
{
    public function __construct(
        private readonly MediaRepositoryInterface $mediaRepository,
    ) {
    }

    /**
     * @return Media[]
     */
    public function findById(int $id): ?Media
    {
        return $this->mediaRepository->findById($id);
    }

    /**
     * @return Media[]
     */
    public function listByFolder(int $folderId): array
    {
        return $this->mediaRepository->findByFolderId($folderId);
    }

    public function createMedia(
        int $folderId,
        int $ownerAdminId,
        string $telegramFileId,
        string $type,
        ?string $caption = null,
        ?string $thumbnailFileId = null,
    ): Media {
        // In a real implementation, id would be generated by persistence layer.
        $media = new Media(
            0,
            $folderId,
            $ownerAdminId,
            $telegramFileId,
            $type,
            $thumbnailFileId,
        );

        if ($caption !== null) {
            $media->setCaption($caption);
        }

        $this->mediaRepository->save($media);

        return $media;
    }

    public function updateMedia(Media $media): void
    {
        $this->mediaRepository->save($media);
    }
}



