<?php

declare(strict_types=1);

namespace Bot\Domain\Service;

use Bot\Domain\Entity\User;
use Bot\Domain\Repository\UserRepositoryInterface;

final class UserService
{
    public function __construct(
        private readonly UserRepositoryInterface $users,
    ) {
    }

    public function getOrCreateByTelegramId(int $telegramId): User
    {
        $existing = $this->users->findByTelegramId($telegramId);
        if ($existing instanceof User) {
            return $existing;
        }

        // In a real implementation, id would be generated by persistence layer.
        $user = new User(0, $telegramId);
        $this->users->save($user);

        return $user;
    }

    public function upgradeToPremium(User $user): void
    {
        $user->upgradeToPremium();
        $this->users->save($user);
    }

    /**
     * @return User[]
     */
    public function getAll(): array
    {
        return $this->users->getAll();
    }
}



