<?php

declare(strict_types=1);

namespace Bot\Infrastructure\Repository;

use Bot\Domain\Entity\Media;
use Bot\Domain\Repository\MediaRepositoryInterface;

/**
 * پیاده‌سازی in-memory برای مدیاها.
 * توجه: شناسه‌ها در دامین مقداردهی می‌شوند و این ریپوزیتوری فقط اشیاء را در حافظه نگه می‌دارد.
 */
final class InMemoryMediaRepository implements MediaRepositoryInterface
{
    /** @var array<int,Media> keyed by id */
    private array $mediaById = [];

    /** @var array<int,list<Media>> keyed by folder_id */
    private array $mediaByFolderId = [];

    public function findById(int $id): ?Media
    {
        return $this->mediaById[$id] ?? null;
    }

    /**
     * @return Media[]
     */
    public function findByFolderId(int $folderId): array
    {
        return $this->mediaByFolderId[$folderId] ?? [];
    }

    public function save(Media $media): void
    {
        $id       = $media->getId();
        $folderId = $media->getFolderId();

        $this->mediaById[$id] = $media;

        if (!isset($this->mediaByFolderId[$folderId])) {
            $this->mediaByFolderId[$folderId] = [];
        }

        $this->mediaByFolderId[$folderId][$id] = $media;
    }
}


