#!/bin/bash

# اسکریپت اجرای ربات Telegram
# استفاده: ./start.sh

cd "$(dirname "$0")"

# بررسی وجود فایل .env
if [ ! -f .env ]; then
    echo "❌ فایل .env یافت نشد!"
    echo "لطفاً فایل .env را ایجاد کنید و BOT_TOKEN را تنظیم کنید."
    exit 1
fi

# بررسی وجود PHP
if ! command -v php &> /dev/null; then
    echo "❌ PHP نصب نشده است!"
    exit 1
fi

echo "🚀 در حال اجرای ربات..."
echo "برای توقف ربات، Ctrl+C را فشار دهید"

# اجرای ربات
php public/index.php

