#!/bin/bash

# اسکریپت بررسی وضعیت ربات
# استفاده: ./status.sh

cd "$(dirname "$0")"

PID_FILE="bot.pid"

if [ ! -f "$PID_FILE" ]; then
    echo "❌ ربات در حال اجرا نیست (فایل PID یافت نشد)"
    exit 1
fi

PID=$(cat "$PID_FILE")

if ps -p "$PID" > /dev/null 2>&1; then
    echo "✅ ربات در حال اجرا است"
    echo "PID: $PID"
    echo ""
    echo "اطلاعات Process:"
    ps -p "$PID" -o pid,ppid,cmd,etime,pcpu,pmem
    echo ""
    if [ -f "bot.log" ]; then
        echo "آخرین خطوط لاگ:"
        tail -n 5 bot.log
    fi
else
    echo "❌ ربات در حال اجرا نیست (Process یافت نشد)"
    rm -f "$PID_FILE"
    exit 1
fi

