#!/bin/bash
# -*- coding: utf-8 -*-

# Script to check bot log file
# Usage: ./check-log.sh [lines]

export LANG=en_US.UTF-8
export LC_ALL=en_US.UTF-8

cd "$(dirname "$0")"

LOG_FILE="bot.log"
LINES=${1:-100}

if [ ! -f "$LOG_FILE" ]; then
    echo "Log file not found: $LOG_FILE"
    exit 1
fi

echo "=== Last $LINES lines of bot.log ==="
echo ""
tail -n "$LINES" "$LOG_FILE"
echo ""
echo "=== End of log ==="
echo ""

# نمایش خطاها و exceptions
echo "=== Errors and Exceptions (last 20) ==="
grep -i "error\|exception\|fatal\|warning" "$LOG_FILE" | tail -n 20 || echo "No errors found in log"
echo ""
echo ""
echo "=== Log file info ==="
if command -v stat >/dev/null 2>&1; then
    LOG_SIZE=$(stat -c %s "$LOG_FILE" 2>/dev/null || stat -f %z "$LOG_FILE" 2>/dev/null)
    LOG_MTIME=$(stat -c %Y "$LOG_FILE" 2>/dev/null || stat -f %m "$LOG_FILE" 2>/dev/null)
    CURRENT_TIME=$(date +%s)
    LOG_AGE=$((CURRENT_TIME - LOG_MTIME))
    
    echo "File size: $LOG_SIZE bytes"
    echo "Last modified: $(date -d "@$LOG_MTIME" 2>/dev/null || date -r "$LOG_MTIME" 2>/dev/null)"
    echo "Age: $LOG_AGE seconds ($(($LOG_AGE / 60)) minutes)"
    
    if [ $LOG_AGE -gt 300 ]; then
        echo "⚠️  Warning: Log file is old (more than 5 minutes)"
    fi
fi

