<?php

declare(strict_types=1);

use Dotenv\Dotenv;

require __DIR__ . '/../../vendor/autoload.php';

// Load environment variables from .env if present
$dotenv = Dotenv::createImmutable(__DIR__ . '/../..');
$dotenv->load();

$botToken = $_ENV['BOT_TOKEN'] ?? null;
if ($botToken === null || $botToken === '') {
    throw new RuntimeException('BOT_TOKEN env variable is required.');
}

$forcedJoinChannel = $_ENV['FORCED_JOIN_CHANNEL'] ?? null; // مثال: @your_channel
$ownerTelegramId   = isset($_ENV['OWNER_TELEGRAM_ID'])
    ? (int) $_ENV['OWNER_TELEGRAM_ID']
    : null;

// Payment gateway configuration
$nextpayApiKey = $_ENV['NEXTPAY_API_KEY'] ?? '';
$zarinpalMerchantId = $_ENV['ZARINPAL_MERCHANT_ID'] ?? '';
$zarinpalSandbox = isset($_ENV['ZARINPAL_SANDBOX']) && $_ENV['ZARINPAL_SANDBOX'] === 'true';
$paymentCallbackBaseUrl = $_ENV['PAYMENT_CALLBACK_BASE_URL'] ?? 'https://yourdomain.com/payment_callback.php';

// محدودیت‌های سیستم
$freeDownloadLimit = 3;

// Database configuration (optional)
$dbHost = $_ENV['DB_HOST'] ?? 'localhost';
$dbPort = isset($_ENV['DB_PORT']) ? (int) $_ENV['DB_PORT'] : 3306;
$dbName = $_ENV['DB_DATABASE'] ?? $_ENV['DB_NAME'] ?? '';
$dbUser = $_ENV['DB_USERNAME'] ?? $_ENV['DB_USER'] ?? '';
$dbPass = $_ENV['DB_PASSWORD'] ?? '';

// Database configuration (optional) - فقط برای استفاده در callback-query
// متغیر $databaseInstalled در callback-query.php محاسبه می‌شود

