<?php

declare(strict_types=1);

namespace Bot\Domain\Entity;

final class Ad
{
    public function __construct(
        private readonly int $id,
        private readonly int $ownerAdminId,
        private string $text,
        private ?string $bannerUrl,
        private int $frequency, // show ad every N messages
        private bool $enabled = true,
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getOwnerAdminId(): int
    {
        return $this->ownerAdminId;
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function setText(string $text): void
    {
        $this->text = $text;
    }

    public function getBannerUrl(): ?string
    {
        return $this->bannerUrl;
    }

    public function setBannerUrl(?string $bannerUrl): void
    {
        $this->bannerUrl = $bannerUrl;
    }

    public function getFrequency(): int
    {
        return $this->frequency;
    }

    public function setFrequency(int $frequency): void
    {
        $this->frequency = $frequency;
    }

    public function toggle(bool $enabled): void
    {
        $this->enabled = $enabled;
    }
}


