<?php

declare(strict_types=1);

namespace Bot\Domain\Entity;

final class Admin
{
    public function __construct(
        private readonly int $id,
        private readonly int $telegramId,
        private readonly bool $isOwner = false,
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getTelegramId(): int
    {
        return $this->telegramId;
    }

    public function isOwner(): bool
    {
        return $this->isOwner;
    }
}


