<?php

declare(strict_types=1);

namespace Bot\Domain\Repository;

use Bot\Domain\Entity\AnalyticsEvent;

interface AnalyticsRepositoryInterface
{
    public function save(AnalyticsEvent $event): void;

    /**
     * @return AnalyticsEvent[]
     */
    public function findByType(string $type): array;

    /**
     * @return AnalyticsEvent[]
     */
    public function findByMediaId(int $mediaId): array;

    /**
     * @return AnalyticsEvent[]
     */
    public function findByUserId(int $userId): array;

    /**
     * @return AnalyticsEvent[]
     */
    public function getAll(): array;

    /**
     * @return AnalyticsEvent[]
     */
    public function findByDateRange(\DateTimeImmutable $startDate, \DateTimeImmutable $endDate): array;

    /**
     * @return AnalyticsEvent[]
     */
    public function findByUserIdAndDateRange(int $userId, \DateTimeImmutable $startDate, \DateTimeImmutable $endDate): array;
}



