<?php

declare(strict_types=1);

namespace Bot\Domain\Repository;

use Bot\Domain\Entity\User;

interface UserRepositoryInterface
{
    public function findByTelegramId(int $telegramId): ?User;

    /**
     * @return User[]
     */
    public function getAll(): array;

    public function save(User $user): void;
}


