<?php

declare(strict_types=1);

namespace Bot\Domain\Service;

use Bot\Domain\Entity\Ad;
use Bot\Domain\Repository\AdsRepositoryInterface;

final class AdsService
{
    public function __construct(
        private readonly AdsRepositoryInterface $adsRepository,
    ) {
    }

    /**
     * @return Ad[]
     */
    public function getEnabledAdsForAdmin(int $ownerAdminId): array
    {
        return $this->adsRepository->findEnabledByOwnerAdminId($ownerAdminId);
    }

    /**
     * @return Ad[]
     */
    public function getAllAdsForAdmin(int $ownerAdminId): array
    {
        return $this->adsRepository->findByOwnerAdminId($ownerAdminId);
    }

    public function createAd(
        int $ownerAdminId,
        string $text,
        ?string $bannerUrl = null,
        int $frequency = 1,
    ): Ad {
        $ad = new Ad(0, $ownerAdminId, $text, $bannerUrl, $frequency, true);
        $this->adsRepository->save($ad);
        return $ad;
    }

    public function updateAd(Ad $ad): void
    {
        $this->adsRepository->save($ad);
    }

    public function deleteAd(int $id): bool
    {
        $ad = $this->adsRepository->findById($id);
        if ($ad === null) {
            return false;
        }
        $this->adsRepository->delete($id);
        return true;
    }

    public function findById(int $id): ?Ad
    {
        return $this->adsRepository->findById($id);
    }
}



