#!/bin/bash
# -*- coding: utf-8 -*-

# Script to run Telegram Bot
# Usage: ./start.sh

export LANG=en_US.UTF-8
export LC_ALL=en_US.UTF-8

cd "$(dirname "$0")"

# Check if .env file exists
if [ ! -f .env ]; then
    echo "Error: .env file not found!"
    echo "Please create .env file and set BOT_TOKEN."
    exit 1
fi

# Check if PHP is installed
if ! command -v php &> /dev/null; then
    echo "Error: PHP is not installed!"
    exit 1
fi

echo "Starting bot..."
echo "Press Ctrl+C to stop"

# Run bot
php public/index.php

