<?php
declare(strict_types=1);

namespace NewUploader;

/**
 * درایور ذخیره‌سازی مبتنی بر MySQL
 * از ساختار جداول فعلی (user, files, userfiles) استفاده می‌کند.
 */
class StorageMysql implements StorageDriverInterface
{
    private \mysqli $db;

    public function __construct(\mysqli $db)
    {
        $this->db = $db;
    }

    public function ensureUser(int $id, ?string $name = null): void
    {
        $id = (int)$id;
        $res = $this->db->query("SELECT `id` FROM `user` WHERE `id` = {$id} LIMIT 1");
        if ($res && $res->num_rows === 0) {
            $time = date('Y-m-d H:i:s');
            $nameEsc = $name !== null ? ("'" . $this->db->real_escape_string($name) . "'") : "NULL";
            $this->db->query(
                "INSERT INTO `user` (`id`, `step`, `step2`, `step3`, `step4`, `step5`, `spam`, `timejoin`, `name`)
                 VALUES ({$id}, '', '', '', '', '', 'no', '{$time}', {$nameEsc})"
            );
        }
    }

    public function getUserStep(int $id): string
    {
        $id = (int)$id;
        $res = $this->db->query("SELECT `step` FROM `user` WHERE `id` = {$id} LIMIT 1");
        if ($res && $row = $res->fetch_assoc()) {
            return (string)$row['step'];
        }
        return '';
    }

    public function setUserStep(int $id, string $step): void
    {
        $id = (int)$id;
        $stepEsc = $this->db->real_escape_string($step);
        $this->db->query("UPDATE `user` SET `step` = '{$stepEsc}' WHERE `id` = {$id} LIMIT 1");
    }

    public function generateUniqueFileCode(int $length = 6): string
    {
        $chars = 'ABCDEFGHJKMNPQRSTUVWXYZ23456789';

        while (true) {
            $code = '';
            for ($i = 0; $i < $length; $i++) {
                $code .= $chars[random_int(0, strlen($chars) - 1)];
            }
            $codeEsc = $this->db->real_escape_string($code);
            $res = $this->db->query("SELECT `code` FROM `files` WHERE `code` = '{$codeEsc}' LIMIT 1");
            if (!$res || $res->num_rows === 0) {
                return $code;
            }
        }
    }

    public function saveFile(array $data): void
    {
        $codeEsc   = $this->db->real_escape_string($data['code']);
        $fileIdEsc = $this->db->real_escape_string($data['file_id']);
        $capEsc    = $this->db->real_escape_string($data['caption'] ?? '');
        $thumbEsc  = $data['thumbnail'] !== null
            ? ("'" . $this->db->real_escape_string((string)$data['thumbnail']) . "'")
            : "NULL";
        $typeEsc   = $this->db->real_escape_string($data['type']);
        $fileSize  = (int)($data['file_size'] ?? 0);
        $userId    = (int)$data['user_id'];

        $sql = "INSERT INTO `files`
            (`code`,`msg_id`,`ghfl_ch`,`zd_filter`,`id`,`dl`,`pass`,`mahdodl`,`zaman`,
             `likes`,`dislikes`,`file_id`,`file_size`,`caption`,`type`,`thumbnail`,`fwlock`)
            VALUES
            ('{$codeEsc}', NULL, NULL, NULL, {$userId}, 0, NULL, NULL, NULL,
             0, 0, '{$fileIdEsc}', '{$fileSize}', '{$capEsc}', '{$typeEsc}', {$thumbEsc}, NULL)";

        $this->db->query($sql);
    }

    public function saveUserFile(int $userId, string $code, string $fileId, string $caption, string $type): void
    {
        $userId  = (int)$userId;
        $codeEsc = $this->db->real_escape_string($code);
        $fileIdEsc = $this->db->real_escape_string($fileId);
        $capEsc  = $this->db->real_escape_string($caption);
        $typeEsc = $this->db->real_escape_string($type);

        $sql = "INSERT INTO `userfiles` (`code`, `id`, `file_id`, `caption`, `type`)
                VALUES ('{$codeEsc}', {$userId}, '{$fileIdEsc}', '{$capEsc}', '{$typeEsc}')";
        $this->db->query($sql);
    }
}


