<?php
declare(strict_types=1);

namespace NewUploader;

/**
 * لایه ساده برای کار با Telegram Bot API
 */
class Telegram
{
    private string $apiKey;
    private string $apiUrl;

    public function __construct(string $apiKey)
    {
        $this->apiKey = $apiKey;
        $this->apiUrl = "https://api.telegram.org/bot{$this->apiKey}/";
    }

    /**
     * فراخوانی متد خام
     */
    public function call(string $method, array $params = []): array
    {
        $ch = curl_init($this->apiUrl . $method);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => $params,
        ]);

        $res = curl_exec($ch);
        if ($res === false) {
            $error = curl_error($ch);
            curl_close($ch);
            return ['ok' => false, 'error' => $error];
        }
        curl_close($ch);

        $data = json_decode($res, true);
        if (!is_array($data)) {
            return ['ok' => false, 'error' => 'bad_json', 'raw' => $res];
        }

        return $data;
    }

    public function sendMessage(int $chatId, string $text, array $extra = []): array
    {
        $params = array_merge([
            'chat_id'    => $chatId,
            'text'       => $text,
            'parse_mode' => 'HTML',
        ], $extra);

        return $this->call('sendMessage', $params);
    }

    public function editMessageText(int $chatId, int $messageId, string $text, array $extra = []): array
    {
        $params = array_merge([
            'chat_id'    => $chatId,
            'message_id' => $messageId,
            'text'       => $text,
            'parse_mode' => 'HTML',
        ], $extra);

        return $this->call('editMessageText', $params);
    }

    public function answerCallbackQuery(string $callbackId, string $text = '', bool $showAlert = false): array
    {
        $params = [
            'callback_query_id' => $callbackId,
        ];
        if ($text !== '') {
            $params['text'] = $text;
        }
        if ($showAlert) {
            $params['show_alert'] = true;
        }

        return $this->call('answerCallbackQuery', $params);
    }
}


